/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UserPasswordCallbackHandler
implements CallbackHandler {
    private String userName;
    private char[] password;
    private String theWebLogicURL = "t3://unconfigured-host:7001";
    private static String webLogicCallBackClassName = "weblogic.security.auth.callback.URLCallback";
    private static String WSCredTokenCallbackImpl = "com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl";

    public UserPasswordCallbackHandler(String userName, char[] password, String webLogicURL) {
        this.userName = userName;
        this.password = password;
        this.theWebLogicURL = webLogicURL;
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof TextOutputCallback) {
                TextOutputCallback toc = (TextOutputCallback)callbacks[i];
                switch (toc.getMessageType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        System.out.println("ERROR: " + toc.getMessage());
                        break;
                    }
                    case 1: {
                        System.out.println("WARNING: " + toc.getMessage());
                        break;
                    }
                    default: {
                        throw new IOException("Unsupported message type: " + toc.getMessageType());
                    }
                }
                continue;
            }
            if (callbacks[i].getClass().getName().equals(webLogicCallBackClassName)) {
                this.callWebLogicSetURL(callbacks[i]);
                continue;
            }
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(this.userName);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(this.password);
                continue;
            }
            if (callbacks[i].getClass().getName().equals(WSCredTokenCallbackImpl)) continue;
            throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
        }
    }

    private void callWebLogicSetURL(Callback obj) throws UnsupportedCallbackException {
        Class<?> webLogicCallBack = null;
        Class[] params = new Class[]{String.class};
        Method method = null;
        try {
            webLogicCallBack = Class.forName(webLogicCallBackClassName);
            method = webLogicCallBack.getMethod("setURL", params);
            String url = this.theWebLogicURL;
            Object[] args = new Object[]{url};
            method.invoke((Object)obj, args);
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedCallbackException(obj, "Class " + webLogicCallBack.getName() + " is missing the setURL method");
        }
        catch (IllegalAccessException iae) {
            throw new UnsupportedCallbackException(obj, "Class " + webLogicCallBack.getName() + " is missing the setURL method");
        }
        catch (InvocationTargetException ite) {
            throw new UnsupportedCallbackException(obj, "Class " + webLogicCallBack.getName() + " is missing the setURL method");
        }
        catch (ClassNotFoundException cnfe) {
            throw new UnsupportedCallbackException(obj, "Class not found " + webLogicCallBackClassName);
        }
    }
}

